//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: When the TCQ00 starts and the counter value is the same as T00REG, the TCQ00 interrupt occurs.
//				  At this point, P90 output level is inverted. 
//				  When the TCQ01 starts and the counter value is the same as T01REG, the TCQ01 interrupt occurs.
//				  At this point, P91 output level is inverted.
//******************************************
//Stack Pointer	=	0x23f (If use mq6821_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6821.h"
#include "MQ6812_REG_BIT.h"

void main()
{
//============================================
// setting and start TCQ00
//============================================
    P9CR.bit.b0	=1;			//set P90 output
 	__asm("DI");	
	POFFCR0.bit.b4=1; 		//[-.TC045EN,TC023EN,TC001EN	-,-,-,TCA0EN]
							//enable TC00 and TC01 
	EIRH.bit.b4=1; 			//[-,INTTCA0,INTTC01,INTTC00	INTRTC,INTADC,INTLVD,-]
							//enable TC00 interrupt
	__asm("EI");
	T00MOD.byte=0xF8;		//[TFF0,DBE0,TCK0[3],-,TCM0]
							//<DBE0>=1,<TCK0>=111,<TCM0>=0 10-bit timer mode
	T00REGL.byte=0x5; 		//set timer value
	T00REGH.byte=0x1; 		//set timer value = 0x0105
	T001CR.bit.b0=1; 		//[-,-,-,COMPSL	  OUTAND,-,T01RUN,T00RUN]
							//start TCQ00   
	
//============================================
// setting and start TCQ01
//============================================
    P9CR.bit.b1	=1;			//set P90 output
 	__asm("DI");	
	POFFCR0.bit.b4=1;		//[-.TC045EN,TC023EN,TC001EN	-,-,-,TCA0EN]
							//enable TC00 and TC01 
	EIRH.bit.b5=1; 			//[-,INTTCA0,INTTC01,INTTC00	INTRTC,INTADC,INTLVD,-]
							//enable TC01 interrupt
	__asm("EI");
	T01MOD.byte=0xF8;		//[TFF,-,TCK[3],-,TCM]
							//<TCK>=111,<TCM>=0 10-bit timer mode
	T01REGL.byte=0x5; 		//set timer value
	T01REGH.byte=0x1; 		//set timer value = 0x0105
	T001CR.bit.b1=1; 		//[-,-,-,COMPSL	  OUTAND,-,T01RUN,T00RUN]
							//start TCQ01  	
		//****************************
		// In MQ6812A ,INTTC01(03,05)  is not enable, if T00(02,04)RUN is 0
		// it will fix in the next version
		// **************************
    while(1)
	{
		WDCDR.byte= 0x4e;	//clear wdt
	}  
	
}
